// background.js - V10.0
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "FETCH_AUTOCOMPLETE") {
    const query = request.query;
    const url = `https://suggestqueries.google.com/complete/search?output=firefox&q=${encodeURIComponent(query)}&hl=tr`;

    fetch(url)
      .then(res => res.json())
      .then(data => {
        // data[1] öneriler listesidir
        sendResponse({ success: true, suggestions: data[1] || [] });
      })
      .catch(err => {
        console.error("Google Fetch Hatası:", err);
        sendResponse({ success: false, error: err.message });
      });

    return true; // ASENKRON YANIT İÇİN BU SATIR ŞARTTIR
  }
});